package edu.uky.ai.sl.ex;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import edu.uky.ai.data.LabeledDataSet;
import edu.uky.ai.sl.Learner;
import edu.uky.ai.sl.Main;
import edu.uky.ai.sl.MajorityLearner;
import edu.uky.ai.sl.Settings;
import edu.uky.ai.sl.dt.DecisionTreeLearner;
import edu.uky.ai.sl.knn.KNNLearner;
import edu.uky.ai.sl.nb.NaiveBayesLearner;
import edu.uky.ai.sl.nn.NeuralNetworkLearner;
import edu.uky.ai.sl.rnd.RandomLearner;

public class Test {

	// You can comment some of these out if you only want to compare certain learners.
	public static Learner[] LEARNERS = new Learner[] {
		new ExampleLearner(),
		new RandomLearner(),
		new MajorityLearner(),
		new KNNLearner(),
		new NaiveBayesLearner(),
		new DecisionTreeLearner(),
		new NeuralNetworkLearner()
	};
	
	// You can comment some of these out if you only want to test on certain data sets.
	public static final String[] DATA_SETS = new String[] {
		"data/tennis.csv",
		"data/iris.csv",
		"data/wine.csv",
		"data/zoo.csv",
		"data/heart.csv",
		"data/car.csv",
	};
	
	public static void main(String[] args) throws Exception {
		LabeledDataSet[] dataSets = new LabeledDataSet[DATA_SETS.length];
		for(int i=0; i<dataSets.length; i++) {
			System.out.println("Reading data set \"" + DATA_SETS[i] + "\"...");
			dataSets[i] = LabeledDataSet.read(new File(DATA_SETS[i]));
		}
		try(OutputStream output = new BufferedOutputStream(new FileOutputStream(new File("results.html")))) {
			Main.benchmark(LEARNERS, dataSets, Settings.DEFAULT_TRAINING_TIME_LIMIT, Settings.DEFAULT_CLASSIFICATION_TIME_LIMIT, output);
		}
	}
}
